/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import wile.redstonepen.libmc.Auxiliaries;

public class ExtendedShapelessRecipe
extends ShapelessRecipe
implements CraftingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final CompoundTag aspects;
    private final ResourceLocation resultTag;
    private final ItemStack result;

    public ExtendedShapelessRecipe(ResourceLocation id, String group, CraftingBookCategory cat, ItemStack output, NonNullList<Ingredient> ingredients, CompoundTag aspects, ResourceLocation resultTag) {
        super(id, group, cat, output, ingredients);
        this.aspects = aspects;
        this.resultTag = resultTag;
        this.result = output;
    }

    public CompoundTag getAspects() {
        return this.aspects.m_6426_();
    }

    private int getToolDamage() {
        if (this.aspects.m_128441_("tool_repair")) {
            return -Mth.m_14045_((int)this.aspects.m_128451_("tool_repair"), (int)0, (int)4096);
        }
        if (this.aspects.m_128441_("tool_damage")) {
            return Mth.m_14045_((int)this.aspects.m_128451_("tool_damage"), (int)1, (int)1024);
        }
        return 0;
    }

    private boolean isRepair() {
        return this.getToolDamage() < 0;
    }

    private Tuple<ItemStack, NonNullList<ItemStack>> getRepaired(CraftingContainer inv) {
        ItemStack stack;
        int i;
        String tool_name = this.aspects.m_128461_("tool");
        HashMap<Item, Integer> repair_items = new HashMap<Item, Integer>();
        NonNullList remaining = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        ItemStack tool_item = ItemStack.f_41583_;
        for (int i2 = 0; i2 < inv.m_6643_(); ++i2) {
            ItemStack stack2 = inv.m_8020_(i2);
            if (stack2.m_41619_()) continue;
            if (Auxiliaries.getResourceLocation(stack2.m_41720_()).toString().equals(tool_name)) {
                tool_item = stack2.m_41777_();
                continue;
            }
            remaining.set(i2, (Object)stack2.m_41777_());
            repair_items.put(stack2.m_41720_(), stack2.m_41613_() + repair_items.getOrDefault(stack2.m_41720_(), 0));
        }
        if (tool_item.m_41619_()) {
            return new Tuple((Object)ItemStack.f_41583_, (Object)remaining);
        }
        if (!tool_item.m_41763_()) {
            Auxiliaries.logWarn("Repairing '" + Auxiliaries.getResourceLocation(tool_item.m_41720_()) + "' can't work, the item is not damageable.");
            return new Tuple((Object)ItemStack.f_41583_, (Object)remaining);
        }
        int dmg = tool_item.m_41773_();
        if (dmg <= 0 && !this.aspects.m_128471_("over_repair")) {
            return new Tuple((Object)ItemStack.f_41583_, (Object)remaining);
        }
        int min_repair_item_count = repair_items.values().stream().mapToInt(Integer::intValue).min().orElse(0);
        if (min_repair_item_count <= 0) {
            return new Tuple((Object)ItemStack.f_41583_, (Object)remaining);
        }
        int single_repair_dur = this.aspects.m_128471_("relative_repair_damage") ? Math.max(1, -this.getToolDamage() * tool_item.m_41776_() / 100) : Math.max(1, -this.getToolDamage());
        int num_repairs = dmg / single_repair_dur;
        if (num_repairs * single_repair_dur < dmg) {
            ++num_repairs;
        }
        num_repairs = Math.min(num_repairs, min_repair_item_count);
        for (Item ki : repair_items.keySet()) {
            repair_items.put(ki, num_repairs);
        }
        tool_item.m_41721_(Math.max(dmg - single_repair_dur * num_repairs, 0));
        for (i = 0; i < remaining.size(); ++i) {
            stack = inv.m_8020_(i);
            if (stack.m_41619_() || Auxiliaries.getResourceLocation(stack.m_41720_()).toString().equals(tool_name)) continue;
            remaining.set(i, (Object)(stack.hasCraftingRemainingItem() ? stack.getCraftingRemainingItem() : stack.m_41777_()));
        }
        for (i = 0; i < remaining.size(); ++i) {
            stack = (ItemStack)remaining.get(i);
            Item item = stack.m_41720_();
            if (!repair_items.containsKey(item)) continue;
            int n = (Integer)repair_items.get(item);
            if (stack.m_41613_() >= n) {
                stack.m_41774_(n);
                repair_items.remove(item);
                continue;
            }
            repair_items.put(item, n - stack.m_41613_());
            remaining.set(i, (Object)ItemStack.f_41583_);
        }
        if (tool_item.m_41720_() instanceof IRepairableToolItem) {
            tool_item = ((IRepairableToolItem)tool_item.m_41720_()).onShapelessRecipeRepaired(tool_item, dmg, tool_item.m_41773_());
        }
        return new Tuple((Object)tool_item, (Object)remaining);
    }

    public boolean m_5598_() {
        return this.isRepair() || this.aspects.m_128471_("dynamic");
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        if (this.isRepair()) {
            NonNullList remaining = (NonNullList)this.getRepaired(inv).m_14419_();
            for (int i = 0; i < remaining.size(); ++i) {
                ItemStack rem_stack = (ItemStack)remaining.get(i);
                ItemStack inv_stack = inv.m_8020_(i);
                if (inv_stack.m_41619_() || !rem_stack.m_41619_() && !inv.m_8020_(i).m_150930_(rem_stack.m_41720_())) continue;
                remaining.set(i, (Object)ItemStack.f_41583_);
                rem_stack.m_41769_(1);
                inv.m_6836_(i, rem_stack);
            }
            return remaining;
        }
        String tool_name = this.aspects.m_128461_("tool");
        int tool_damage = this.getToolDamage();
        NonNullList remaining = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (Auxiliaries.getResourceLocation(stack.m_41720_()).toString().equals(tool_name)) {
                if (!stack.m_41763_()) {
                    remaining.set(i, (Object)stack);
                    continue;
                }
                ItemStack rstack = stack.m_41777_();
                rstack.m_41721_(rstack.m_41773_() + tool_damage);
                if (rstack.m_41773_() >= rstack.m_41776_()) continue;
                remaining.set(i, (Object)rstack);
                continue;
            }
            if (!stack.hasCraftingRemainingItem()) continue;
            remaining.set(i, (Object)stack.getCraftingRemainingItem());
        }
        return remaining;
    }

    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess ra) {
        int dmg;
        if (this.isRepair()) {
            return (ItemStack)this.getRepaired(inv).m_14418_();
        }
        ItemStack rstack = super.m_5874_(inv, ra);
        if (rstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (this.aspects.m_128451_("initial_durability") > 0) {
            int dmg2 = Math.max(0, rstack.m_41776_() - this.aspects.m_128451_("initial_durability"));
            if (dmg2 > 0) {
                rstack.m_41721_(dmg2);
            }
        } else if (this.aspects.m_128451_("initial_damage") > 0 && (dmg = Math.min(this.aspects.m_128451_("initial_damage"), rstack.m_41776_())) > 0) {
            rstack.m_41721_(dmg);
        }
        return rstack;
    }

    public ItemStack m_8043_(RegistryAccess ra) {
        return this.getResultItem();
    }

    public ItemStack getResultItem() {
        return this.m_5598_() ? ItemStack.f_41583_ : this.result;
    }

    public static interface IRepairableToolItem {
        public ItemStack onShapelessRecipeRepaired(ItemStack var1, int var2, int var3);
    }

    public static class Serializer
    implements RecipeSerializer<ExtendedShapelessRecipe> {
        private static final int MAX_WIDTH = 3;
        private static final int MAX_HEIGHT = 3;

        public ExtendedShapelessRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject res;
            JsonObject aspects;
            ResourceLocation resultTag = new ResourceLocation("libmc", "none");
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList list = NonNullList.m_122779_();
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredients.get(i));
                if (ingredient.m_43947_()) continue;
                list.add((Object)ingredient);
            }
            if (list.isEmpty()) {
                throw new JsonParseException("No ingredients for " + recipeId.m_135815_() + " recipe");
            }
            if (list.size() > 9) {
                throw new JsonParseException("Too many ingredients for crafting_tool_shapeless recipe the max is 9");
            }
            CompoundTag aspects_nbt = new CompoundTag();
            if (json.get("aspects") != null && (aspects = GsonHelper.m_13930_((JsonObject)json, (String)"aspects")).size() > 0) {
                try {
                    aspects_nbt = TagParser.m_129359_((String)new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson((JsonElement)aspects));
                }
                catch (Exception ex) {
                    throw new JsonParseException(recipeId.m_135815_() + ": Failed to parse the 'aspects' object:" + ex.getMessage());
                }
            }
            if ((res = GsonHelper.m_13930_((JsonObject)json, (String)"result")).has("tag")) {
                ResourceLocation rl = new ResourceLocation(res.get("tag").getAsString());
                TagKey key = ForgeRegistries.ITEMS.tags().getTagNames().filter(tag_key -> tag_key.f_203868_().equals((Object)rl)).findFirst().orElse(null);
                if (key == null) {
                    throw new JsonParseException(recipeId.m_135815_() + ": Result tag does not exist: #" + rl);
                }
                ITag tag = ForgeRegistries.ITEMS.tags().getTag(key);
                Item item = tag.stream().findFirst().orElse(null);
                if (item == null) {
                    throw new JsonParseException(recipeId.m_135815_() + ": Result tag has no items: #" + rl);
                }
                if (res.has("item")) {
                    res.remove("item");
                }
                resultTag = rl;
                res.addProperty("item", Auxiliaries.getResourceLocation(item).toString());
            }
            ItemStack result_stack = ShapedRecipe.m_151274_((JsonObject)res);
            return new ExtendedShapelessRecipe(recipeId, group, CraftingBookCategory.MISC, result_stack, (NonNullList<Ingredient>)list, aspects_nbt, resultTag);
        }

        public ExtendedShapelessRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf pkt) {
            String group = pkt.m_130136_(Short.MAX_VALUE);
            int size = pkt.m_130242_();
            NonNullList list = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            list.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)pkt));
            ItemStack stack = pkt.m_130267_();
            CompoundTag aspects = pkt.m_130260_();
            ResourceLocation resultTag = pkt.m_130281_();
            return new ExtendedShapelessRecipe(recipeId, group, CraftingBookCategory.MISC, stack, (NonNullList<Ingredient>)list, aspects, resultTag);
        }

        public void toNetwork(FriendlyByteBuf pkt, ExtendedShapelessRecipe recipe) {
            pkt.m_130070_(recipe.m_6076_());
            pkt.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(pkt);
            }
            pkt.m_130055_(recipe.getResultItem());
            pkt.m_130079_(recipe.getAspects());
            pkt.m_130085_(recipe.resultTag);
        }
    }
}

